/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.capability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemHandlerHelper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.api.type.util.ICuriosHelper;
import top.theillusivec4.curios.api.type.util.ISlotHelper;
import top.theillusivec4.curios.common.inventory.CurioStacksHandler;

public class CurioInventoryCapability {
    public static void register() {
        CapabilityManager.INSTANCE.register(ICuriosItemHandler.class, (Capability.IStorage)new Capability.IStorage<ICuriosItemHandler>(){

            public INBT writeNBT(Capability<ICuriosItemHandler> capability, ICuriosItemHandler instance, Direction side) {
                CompoundNBT compound = new CompoundNBT();
                ListNBT taglist = new ListNBT();
                instance.getCurios().forEach((key, stacksHandler) -> {
                    CompoundNBT tag = new CompoundNBT();
                    tag.func_218657_a("StacksHandler", (INBT)stacksHandler.serializeNBT());
                    tag.func_74778_a("Identifier", key);
                    taglist.add((Object)tag);
                });
                compound.func_218657_a("Curios", (INBT)taglist);
                ListNBT taglist1 = new ListNBT();
                for (String identifier : instance.getLockedSlots()) {
                    taglist1.add((Object)StringNBT.func_229705_a_((String)identifier));
                }
                compound.func_218657_a("Locked", (INBT)taglist1);
                return compound;
            }

            public void readNBT(Capability<ICuriosItemHandler> capability, ICuriosItemHandler instance, Direction side, INBT nbt) {
                ListNBT tagList = ((CompoundNBT)nbt).func_150295_c("Curios", 10);
                ListNBT lockedList = ((CompoundNBT)nbt).func_150295_c("Locked", 8);
                ISlotHelper slotHelper = CuriosApi.getSlotHelper();
                ICuriosHelper curiosHelper = CuriosApi.getCuriosHelper();
                LivingEntity livingEntity = instance.getWearer();
                if (!tagList.isEmpty() && slotHelper != null) {
                    LinkedHashMap<String, ICurioStacksHandler> curios = new LinkedHashMap<String, ICurioStacksHandler>();
                    SortedMap<ISlotType, ICurioStacksHandler> sortedCurios = slotHelper.createSlots();
                    for (int i = 0; i < tagList.size(); ++i) {
                        CompoundNBT tag = tagList.func_150305_b(i);
                        String identifier = tag.func_74779_i("Identifier");
                        CurioStacksHandler prevStacksHandler = new CurioStacksHandler();
                        prevStacksHandler.deserializeNBT(tag.func_74775_l("StacksHandler"));
                        Optional<ISlotType> optionalType = CuriosApi.getSlotHelper().getSlotType(identifier);
                        optionalType.ifPresent(type -> {
                            int index;
                            CurioStacksHandler newStacksHandler = new CurioStacksHandler(type.getSize(), prevStacksHandler.getSizeShift(), type.isVisible(), type.hasCosmetic());
                            for (index = 0; index < newStacksHandler.getSlots() && index < prevStacksHandler.getSlots(); ++index) {
                                ItemStack prevCosmetic;
                                ItemStack prevStack = prevStacksHandler.getStacks().getStackInSlot(index);
                                SlotContext slotContext = new SlotContext(identifier, livingEntity, index);
                                if (!prevStack.func_190926_b()) {
                                    if (curiosHelper.isStackValid(slotContext, prevStack)) {
                                        newStacksHandler.getStacks().setStackInSlot(index, prevStack);
                                    } else {
                                        instance.loseInvalidStack(prevStack);
                                    }
                                }
                                if ((prevCosmetic = prevStacksHandler.getCosmeticStacks().getStackInSlot(index)).func_190926_b()) continue;
                                if (curiosHelper.isStackValid(slotContext, prevCosmetic)) {
                                    newStacksHandler.getCosmeticStacks().setStackInSlot(index, prevStacksHandler.getCosmeticStacks().getStackInSlot(index));
                                    continue;
                                }
                                instance.loseInvalidStack(prevCosmetic);
                            }
                            while (index < prevStacksHandler.getSlots()) {
                                instance.loseInvalidStack(prevStacksHandler.getStacks().getStackInSlot(index));
                                instance.loseInvalidStack(prevStacksHandler.getCosmeticStacks().getStackInSlot(index));
                                ++index;
                            }
                            sortedCurios.put((ISlotType)type, newStacksHandler);
                            for (int j = 0; j < newStacksHandler.getRenders().size() && j < prevStacksHandler.getRenders().size(); ++j) {
                                newStacksHandler.getRenders().set(j, (Object)((Boolean)prevStacksHandler.getRenders().get(j)));
                            }
                        });
                        if (optionalType.isPresent()) continue;
                        IDynamicStackHandler stackHandler = prevStacksHandler.getStacks();
                        IDynamicStackHandler cosmeticStackHandler = prevStacksHandler.getCosmeticStacks();
                        for (int j = 0; j < stackHandler.getSlots(); ++j) {
                            ItemStack cosmeticStack;
                            ItemStack stack = stackHandler.getStackInSlot(j);
                            if (!stack.func_190926_b()) {
                                instance.loseInvalidStack(stack);
                            }
                            if ((cosmeticStack = cosmeticStackHandler.getStackInSlot(j)).func_190926_b()) continue;
                            instance.loseInvalidStack(cosmeticStack);
                        }
                    }
                    sortedCurios.forEach((slotType, stacksHandler) -> curios.put(slotType.getIdentifier(), (ICurioStacksHandler)stacksHandler));
                    instance.setCurios(curios);
                    for (int k = 0; k < lockedList.size(); ++k) {
                        instance.lockSlotType(lockedList.func_150307_f(k));
                    }
                }
            }
        }, CurioInventoryWrapper::new);
    }

    public static ICapabilityProvider createProvider(PlayerEntity playerEntity) {
        return new Provider(playerEntity);
    }

    public static class Provider
    implements ICapabilitySerializable<INBT> {
        final LazyOptional<ICuriosItemHandler> optional;
        final ICuriosItemHandler handler;

        Provider(PlayerEntity playerEntity) {
            this.handler = new CurioInventoryWrapper(playerEntity);
            this.optional = LazyOptional.of(() -> this.handler);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction facing) {
            return CuriosCapability.INVENTORY.orEmpty(capability, this.optional);
        }

        public INBT serializeNBT() {
            return CuriosCapability.INVENTORY.writeNBT((Object)this.handler, null);
        }

        public void deserializeNBT(INBT nbt) {
            CuriosCapability.INVENTORY.readNBT((Object)this.handler, null, nbt);
        }
    }

    public static class CurioInventoryWrapper
    implements ICuriosItemHandler {
        Map<String, ICurioStacksHandler> curios = new LinkedHashMap<String, ICurioStacksHandler>();
        Set<String> locked = new HashSet<String>();
        NonNullList<ItemStack> invalidStacks = NonNullList.func_191196_a();
        PlayerEntity wearer;
        Set<String> toLock = new HashSet<String>();
        List<UnlockState> toUnlock = new ArrayList<UnlockState>();
        Tuple<Integer, Integer> fortuneAndLooting = new Tuple((Object)0, (Object)0);

        CurioInventoryWrapper() {
            this(null);
        }

        CurioInventoryWrapper(PlayerEntity playerEntity) {
            this.wearer = playerEntity;
            this.reset();
        }

        @Override
        public void reset() {
            if (!this.wearer.func_130014_f_().func_201670_d() && this.wearer instanceof ServerPlayerEntity) {
                this.locked.clear();
                this.curios.clear();
                this.invalidStacks.clear();
                CuriosApi.getSlotHelper().createSlots().forEach((slotType, stacksHandler) -> this.curios.put(slotType.getIdentifier(), (ICurioStacksHandler)stacksHandler));
            }
        }

        @Override
        public int getSlots() {
            int totalSlots = 0;
            for (ICurioStacksHandler stacks : this.curios.values()) {
                totalSlots += stacks.getSlots();
            }
            return totalSlots;
        }

        @Override
        public int getVisibleSlots() {
            int totalSlots = 0;
            for (ICurioStacksHandler stacks : this.curios.values()) {
                if (!stacks.isVisible()) continue;
                totalSlots += stacks.getSlots();
            }
            return totalSlots;
        }

        @Override
        public Set<String> getLockedSlots() {
            return Collections.unmodifiableSet(this.locked);
        }

        @Override
        public Optional<ICurioStacksHandler> getStacksHandler(String identifier) {
            return Optional.ofNullable(this.curios.get(identifier));
        }

        @Override
        public Map<String, ICurioStacksHandler> getCurios() {
            return Collections.unmodifiableMap(this.curios);
        }

        @Override
        public void setCurios(Map<String, ICurioStacksHandler> curios) {
            this.curios = curios;
        }

        @Override
        public void unlockSlotType(String identifier, int amount, boolean visible, boolean cosmetic) {
            this.toUnlock.add(new UnlockState(identifier, amount, visible, cosmetic));
        }

        @Override
        public void lockSlotType(String identifier) {
            this.toLock.add(identifier);
        }

        @Override
        public void processSlots() {
            this.toLock.forEach(id -> this.getStacksHandler((String)id).ifPresent(stackHandler -> {
                this.curios.remove(id);
                this.locked.add((String)id);
                this.loseStacks(stackHandler.getStacks(), (String)id, stackHandler.getSlots());
            }));
            this.toUnlock.forEach(state -> {
                this.curios.putIfAbsent(state.identifier, new CurioStacksHandler(state.amount, 0, state.visible, state.cosmetic));
                this.locked.remove(state.identifier);
            });
            this.toLock.clear();
            this.toUnlock.clear();
        }

        @Override
        public void growSlotType(String identifier, int amount) {
            if (amount > 0) {
                this.getStacksHandler(identifier).ifPresent(stackHandler -> stackHandler.grow(amount));
            }
        }

        @Override
        public void shrinkSlotType(String identifier, int amount) {
            if (amount > 0) {
                this.getStacksHandler(identifier).ifPresent(stackHandler -> {
                    int toShrink = Math.min(stackHandler.getSlots() - 1, amount);
                    this.loseStacks(stackHandler.getStacks(), identifier, toShrink);
                    stackHandler.shrink(amount);
                });
            }
        }

        @Override
        @Nullable
        public LivingEntity getWearer() {
            return this.wearer;
        }

        @Override
        public void loseInvalidStack(ItemStack stack) {
            this.invalidStacks.add((Object)stack);
        }

        @Override
        public void handleInvalidStacks() {
            if (this.wearer != null && !this.invalidStacks.isEmpty()) {
                this.invalidStacks.forEach(drop -> ItemHandlerHelper.giveItemToPlayer((PlayerEntity)this.wearer, (ItemStack)drop));
                this.invalidStacks = NonNullList.func_191196_a();
            }
        }

        private void loseStacks(IDynamicStackHandler stackHandler, String identifier, int amount) {
            if (this.wearer != null && !this.wearer.func_130014_f_().func_201670_d()) {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                for (int i = stackHandler.getSlots() - amount; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    drops.add(stackHandler.getStackInSlot(i));
                    SlotContext slotContext = new SlotContext(identifier, (LivingEntity)this.wearer, i);
                    if (!stack.func_190926_b()) {
                        UUID uuid = UUID.nameUUIDFromBytes((identifier + i).getBytes());
                        this.wearer.func_233645_dx_().func_233785_a_(CuriosApi.getCuriosHelper().getAttributeModifiers(slotContext, uuid, stack));
                        int index = i;
                        CuriosApi.getCuriosHelper().getCurio(stack).ifPresent(curio -> curio.onUnequip(identifier, index, (LivingEntity)this.wearer));
                    }
                    stackHandler.setStackInSlot(i, ItemStack.field_190927_a);
                }
                drops.forEach(drop -> ItemHandlerHelper.giveItemToPlayer((PlayerEntity)this.wearer, (ItemStack)drop));
            }
        }

        @Override
        public int getFortuneBonus() {
            return (Integer)this.fortuneAndLooting.func_76341_a();
        }

        @Override
        public int getLootingBonus() {
            return (Integer)this.fortuneAndLooting.func_76340_b();
        }

        @Override
        public void setEnchantmentBonuses(Tuple<Integer, Integer> fortuneAndLootingIn) {
            this.fortuneAndLooting = fortuneAndLootingIn;
        }

        public static class UnlockState {
            final String identifier;
            final int amount;
            final boolean visible;
            final boolean cosmetic;

            UnlockState(String identifier, int amount, boolean visible, boolean cosmetic) {
                this.identifier = identifier;
                this.amount = amount;
                this.visible = visible;
                this.cosmetic = cosmetic;
            }
        }
    }
}

